﻿using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VA.TMP.OptionSets;
using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Delete
{
    /// <summary>
    /// Delete Appointment step.
    /// </summary>
    public class MapAppointmentStep : FilterBase<VideoVisitDeleteStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitDeleteStateObject state)
        {
            var statusCode = GetServiceAppointmentCancelStatusCode(state);

            state.CancelAppointmentRequest = new VIMTTmpCancelAppointmentRequest
            {
                OrganizationName = state.OrganizationName,
                UserId = state.UserId,
                LogTiming = false,
                LogSoap = false,
                Debug = false,
                VIMTTmpCancelAppointmentRequestDataInfo = new VIMTTmpCancelAppointmentRequestData
                {
                    Id = state.AppointmentId.ToString(),
                    Status = new VIMTTmpStatus
                    {
                        Code = statusCode,
                        CodeSpecified = true,
                        Reason = VIMTTmpReasonCode.OTHER,
                        ReasonSpecified = true,
                        Description = statusCode.ToString()
                    }
                }
            };
        }

        /// <summary>
        /// Map the TMP status code to the schema status code.
        /// </summary>
        /// <param name="state"></param>
        /// <returns></returns>
        private static VIMTTmpStatusCode GetServiceAppointmentCancelStatusCode(VideoVisitDeleteStateObject state)
        {
            if (state.ServiceAppointment.StatusCode == null) return VIMTTmpStatusCode.CANCELLED_BY_CLINIC;

            switch (state.ServiceAppointment.StatusCode.Value)
            {
                case (int) serviceappointment_statuscode.ClinicCanceled : return VIMTTmpStatusCode.CANCELLED_BY_CLINIC;
                case (int) serviceappointment_statuscode.PatientCanceled : return VIMTTmpStatusCode.CANCELLED_BY_PATIENT;
                case (int) serviceappointment_statuscode.PatientNoShow : return VIMTTmpStatusCode.NO_SHOW;
                case (int) serviceappointment_statuscode.TechnologyFailure : return VIMTTmpStatusCode.CANCELLED_BY_CLINIC;
                default: return VIMTTmpStatusCode.CANCELLED_BY_CLINIC;
            }
        }
    }
}